USE [EleriumClean]
GO

/****** Object:  StoredProcedure [dbo].[RP_GetUniqueDownloadsForMonth]    Script Date: 10/3/2013 4:42:02 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-23>
-- Description:	<Get the total unique downloads for a given month (not by project just over all unique downloads>
-- Param @firstDayOfMonthToCalculate, pass in the first date of the month that you want to calculate, IE get May 2011 pass in 2011-05-01 xx:xx:xx:xxx ( time doesnt matter is get striped off)
-- =============================================
ALTER PROCEDURE [dbo].[RP_GetUniqueDownloadsForMonth] 
	-- Add the parameters for the stored procedure here
	@firstDayOfMonthToCalculate date
AS
DECLARE @startDate varchar(25), @endDate varchar(25), @uniqueDownloadsForMonth int
BEGIN
	SET NOCOUNT ON;
	-- get the Unique Downloads for the Month
	SELECT @startDate = CONVERT(VARCHAR(25),@firstDayOfMonthToCalculate,101);
	SELECT @endDate = CONVERT(VARCHAR(25), DATEADD(mm, 1, @firstDayOfMonthToCalculate), 101);
    SELECT @uniqueDownloadsForMonth = (SELECT COUNT(DISTINCT IpAddress)
							From [DownloadStatistics].[dbo].Record
							where Date >= @startDate and Date < @endDate)
	-- Now store it in the Table
	INSERT INTO [dbo].[MonthlyEcpmDownloads] 
	(UniqueCount
	,BeginDate
	,EndDate)
	VALUES
	(@uniqueDownloadsForMonth
	,@startDate
	,convert(date, dateadd(dd, -(day(GETUTCDATE()) -1), GETUTCDATE()), 101))
END
GO


